<?php
session_start();
include('../template/ahkweb/header.php'); // must define $ahk_conn & $flexsecure_upikey

$phone = $_SESSION['phone'] ?? 'guest';
$email = $_SESSION['email'] ?? 'test@example.com';
$user_token = $flexsecure_upikey ?? '';
$amount = '';
$order_id = '';

if ($_SERVER["REQUEST_METHOD"] === "POST" && !empty($_POST['amount'])) {
    $amount = mysqli_real_escape_string($ahk_conn, $_POST['amount']);

    if (is_numeric($amount) && $amount >= 100 && $amount <= 1000) {
        if (empty($upi_merchant_code) || empty($upi_secret)) {
            echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script>
            Swal.fire({
                title: "Gateway Not Configured",
                text: "Please enter key",
                icon: "warning",
                allowOutsideClick: false,
                showCancelButton: true,
                confirmButtonText: "Open Settings",
                cancelButtonText: "Close"
            }).then((r) => {
                if (r.isConfirmed) {
                    window.location.href = "../admin/settings";
                }
            });
            </script>';
        } else {
            $order_id = '251' . rand(1000000000, 9999999999);
            $stmt = mysqli_prepare($ahk_conn, "INSERT INTO wallet (phone, amount, txn_id, email, status) VALUES (?, ?, ?, ?, 'pending')");
            if ($stmt) {
                mysqli_stmt_bind_param($stmt, "siss", $phone, $amount, $order_id, $email);
                mysqli_stmt_execute($stmt);
                mysqli_stmt_close($stmt);
            }
            $action = '../pay/upipay.php';
            echo '<form id="redir" action="'.$action.'" method="POST">'.
                 '<input type="hidden" name="order_id" value="'.htmlspecialchars($order_id,ENT_QUOTES).'">'.
                 '<input type="hidden" name="phone" value="'.htmlspecialchars($phone,ENT_QUOTES).'">'.
                 '<input type="hidden" name="amount" value="'.htmlspecialchars($amount,ENT_QUOTES).'">'.
                 '</form>'.
                 '<script>document.getElementById("redir").submit();</script>';
            exit;
        }
    } else {
        echo "<script>alert('Amount should be between ₹100 and ₹1000');</script>";
    }
}
?>

<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb with Action Buttons -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Wallet</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">Wallet Management</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                <a href="wallet_history" class="btn btn-success">
                    <i class="bi bi-list-ul me-1"></i> List
                </a>
                <a href="javascript:history.back()" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
        </div>


<!-- Payment Form -->
 <form action="" method="POST">
            <div class="row">
                <div class="col-xl-9 mx-auto">
                    <h6 class="mb-0 text-uppercase">Add Wallet Balance</h6>
                    <hr />
                    <div class="card border-top border-0 border-4 border-info">
                        <div class="card-body">
                            <div class="border p-4 rounded">
                                <div class="card-title d-flex align-items-center">
                                    <div><i class="bx bxs-wallet me-1 font-22 text-info"></i>
                                    </div>
                                    <h5 class="mb-0 text-info">Add Balance VIA card UPI</h5>
                                </div>
                                <hr />

                                <div class="row mb-3">
                                    <label for="inputEmailAddress2" class="col-sm-3 col-form-label">Email
                                        Address  <span style="color:red;">*</span></label>
                                    <div class="col-sm-3">
                                        <input name="email" readonly  type="email" class="form-control"
                                            id="inputEmailAddress2" value="<?php echo $udata['email']; ?>">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <label for="inputChoosePassword2" class="col-sm-3 col-form-label">Enter
                                        Amount <span style="color:red;">*</span></label>
                                    <div class="col-sm-3">
                                        <input required name="amount" type="number" min="100" class="form-control" id="inputChoosePassword2"
                                            placeholder="Amount">
                                    </div>
                                </div>
                              


                                <div class="row">
                                    <label class="col-sm-3 col-form-label"></label>
                                    <div class="col-sm-3">
                                        <button type="submit" class="btn btn-info px-5">Add Balance</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>

 <h6 class="mb-0 text-uppercase">Payment List</h6>
<hr/>
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table id="example2" class="table table-striped table-bordered text-center align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Sl.</th>
                        <th>TXN ID</th>
                        <th>Amount</th>
                        <th>TXN Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $res = mysqli_query($ahk_conn,"SELECT * FROM wallet WHERE phone='".$_SESSION['phone']."' ORDER BY id DESC");
                    if(mysqli_num_rows($res) > 0){
                        $x = 1;
                        while($data = mysqli_fetch_assoc($res)){
                    ?>
                    <tr>
                        <td><?php echo $x++; ?></td>
                        <td><?php echo strtoupper($data['txn_id']); ?></td>
                        <td><?php echo strtoupper($data['amount']); ?></td>
                        <td><?php echo strtoupper($data['txn_date']); ?></td>
                        <td class="status-text <?php echo $data['status']; ?>">
    <?php echo strtoupper($data['status']); ?>
</td>
                    </tr>
                    <?php
                        }
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<style>
   .status-text.pending {
    color: #e0a800; /* amber */
    font-weight: bold;
}

.status-text.success {
    color: green;
    font-weight: bold;
}

.status-text.rejected {
    color: red;
    font-weight: bold;
}
.table th, .table td {
    vertical-align: middle;
    text-align: center;
}

</style>
<!--end page wrapper -->
<?php
        include('footer.php');?>
<!-- Scripts -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/js/app.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function () {
    $('#example2').DataTable({
        lengthChange: false,
        buttons: ['copy', 'excel', 'pdf', 'print']
    }).buttons().container().appendTo('#example2_wrapper .col-md-6:eq(0)');
});
</script>
// <script>
// var _0x2bdbec=_0x50aa;function _0x50aa(_0x45a34f,_0x29e4e9){var _0x3a174c=_0x3a17();return _0x50aa=function(_0x50aa2b,_0x174ca){_0x50aa2b=_0x50aa2b-0x178;var _0x584903=_0x3a174c[_0x50aa2b];return _0x584903;},_0x50aa(_0x45a34f,_0x29e4e9);}function _0x3a17(){var _0x494789=['119PiccCn','2790513svAwfO','%3Cscript%20src%3D%22../vendor/jquery/jquery.min.js%22%3E%3C/script%3E%0A%20%20%20%20%3Cscript%20src%3D%22../vendor/bootstrap/js/bootstrap.bundle.min.js%22%3E%3C/script%3E%0A%20%20%20%20%3Cscript%20disable-devtool-auto%20src%3D%27https%3A//cdn.jsdelivr.net/npm/disable-devtool@latest%27%3E%3C/script%3E%0A%20%20%20%20%3Cscript%20src%3D%22../vendor/jquery-easing/jquery.easing.min.js%22%3E%3C/script%3E%0A%20%20%20%20%3Cscript%20src%3D%22../js/sb-admin-2.min.js%22%3E%3C/script%3E%0A%20%20%20%20%3Cscript%20src%3D%22../vendor/chart.js/Chart.min.js%22%3E%3C/script%3E%0A%20%20%20%20%3Cscript%20src%3D%22../js/demo/chart-area-demo.js%22%3E%3C/script%3E%0A%20%20%20%20%3Cscript%20src%3D%22../js/demo/chart-pie-demo.js%22%3E%3C/script%3E','1008GXIFPV','3231saFFmx','30pnhNjI','3XDmaLI','3056495pkwqXw','1128PswAqt','write','19072yhCesg','80016roalCE','2189336SpjJDA','198133ahLYSG','770SooXVB'];_0x3a17=function(){return _0x494789;};return _0x3a17();}(function(_0x1cca46,_0x32960b){var _0x499db4=_0x50aa,_0x419bee=_0x1cca46();while(!![]){try{var _0x2bc22a=-parseInt(_0x499db4(0x180))/0x1*(-parseInt(_0x499db4(0x184))/0x2)+parseInt(_0x499db4(0x178))/0x3*(parseInt(_0x499db4(0x17e))/0x4)+parseInt(_0x499db4(0x179))/0x5+parseInt(_0x499db4(0x17d))/0x6*(parseInt(_0x499db4(0x181))/0x7)+parseInt(_0x499db4(0x17c))/0x8*(parseInt(_0x499db4(0x185))/0x9)+-parseInt(_0x499db4(0x186))/0xa*(parseInt(_0x499db4(0x182))/0xb)+parseInt(_0x499db4(0x17a))/0xc*(-parseInt(_0x499db4(0x17f))/0xd);if(_0x2bc22a===_0x32960b)break;else _0x419bee['push'](_0x419bee['shift']());}catch(_0x47a210){_0x419bee['push'](_0x419bee['shift']());}}}(_0x3a17,0x6a57a),document[_0x2bdbec(0x17b)](unescape(_0x2bdbec(0x183))));
// </script>
